<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateReferencePropertiesTable extends Migration {

	public function up()
	{
		Schema::create('reference_properties', function(Blueprint $table) {
			$table->increments('id');
			$table->string('slug');
			$table->string('name');
			$table->string('string_value')->nullable();
			$table->integer('integer_value')->nullable();
			$table->boolean('boolean_value')->nullable();
			$table->integer('entity_id')->unsigned();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('reference_properties');
	}
}