<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateMemberAccountTransactionTable extends Migration {

	public function up()
	{
		Schema::create('MemberAccountTransaction', function(Blueprint $table) {
			$table->integer('MemberID')->unsigned();
			$table->integer('TransactionID')->primary();
			$table->date('TransactionDate');
			$table->decimal('TransactionAmount')->default('0.00');
			$table->integer('TransactionTypeID')->unsigned()->default('Payment');
			$table->string('TransactionNote', 300);
			$table->datetime('ModificationData');
		});
	}

	public function down()
	{
		Schema::drop('MemberAccountTransaction');
	}
}