<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateMenuTable extends Migration {

	public function up()
	{
		Schema::create('menu', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('title', 100)->unique();
			$table->integer('categoryid');
			$table->decimal('price', 15,4);
			$table->integer('taxclass');
			$table->tinyInteger('is_available');
			$table->integer('quantity');
			$table->tinyInteger('stock_status_id');
			$table->text('description');
			$table->text('image');
		});
	}

	public function down()
	{
		Schema::drop('menu');
	}
}