<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAdminUsersTable extends Migration {

	public function up()
	{
		Schema::create('admin_users', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name', 100);
			$table->string('email', 155)->unique();
			$table->bigInteger('mobile');
			$table->tinyInteger('is_active');
			$table->text('image');
			$table->text('password');
		});
	}

	public function down()
	{
		Schema::drop('admin_users');
	}
}