<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateBookingTable extends Migration {

	public function up()
	{
		Schema::create('booking', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('tableid');
			$table->integer('userid');
			$table->string('token', 30)->unique();
			$table->tinyInteger('status');
			$table->integer('addressid');
			$table->integer('totalguest');
			$table->datetime('bkdatetime');
			$table->integer('outletid');
		});
	}

	public function down()
	{
		Schema::drop('booking');
	}
}