<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOutletsTable extends Migration {

	public function up()
	{
		Schema::create('outlets', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('title', 200);
			$table->string('email', 155)->unique();
			$table->string('city', 100);
			$table->integer('pincode');
			$table->bigInteger('contactno');
			$table->text('image');
			$table->text('customfield');
			$table->string('district', 100);
			$table->string('state', 100);
			$table->string('latitude', 10);
			$table->string('longitude', 10);
		});
	}

	public function down()
	{
		Schema::drop('outlets');
	}
}