<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateBlogTable extends Migration {

	public function up()
	{
		Schema::create('blog', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('user_id')->nullable();
			$table->integer('platform_id')->nullable();
			$table->text('link')->nullable();
			$table->string('title')->nullable();
			$table->string('favicon')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('blog');
	}
}