<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class BlogPlatformRequirement extends Eloquent {

	protected $table = 'blog_platform_requirement';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('platform_requirement_id', 'blog_id', 'value');

	public function platform_requirement()
	{
		return $this->belongsTo('PlatformRequirement', 'platform_requirement_id');
	}

	public function blog()
	{
		return $this->belongsTo('Blog', 'blog_id');
	}

}