<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('keluargas', function(Blueprint $table) {
			$table->foreign('leader_id')->references('id')->on('users')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('keluargas', function(Blueprint $table) {
			$table->foreign('state_id')->references('id')->on('states')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('profiles', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('profiles', function(Blueprint $table) {
			$table->foreign('state_id')->references('id')->on('states')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('profiles', function(Blueprint $table) {
			$table->foreign('keluarga_id')->references('id')->on('keluargas')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('ijazah_profile', function(Blueprint $table) {
			$table->foreign('ijazah_id')->references('id')->on('ijazahs')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('ijazah_profile', function(Blueprint $table) {
			$table->foreign('profile_id')->references('id')->on('profiles')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('keluargas', function(Blueprint $table) {
			$table->dropForeign('keluargas_leader_id_foreign');
		});
		Schema::table('keluargas', function(Blueprint $table) {
			$table->dropForeign('keluargas_state_id_foreign');
		});
		Schema::table('profiles', function(Blueprint $table) {
			$table->dropForeign('profiles_user_id_foreign');
		});
		Schema::table('profiles', function(Blueprint $table) {
			$table->dropForeign('profiles_state_id_foreign');
		});
		Schema::table('profiles', function(Blueprint $table) {
			$table->dropForeign('profiles_keluarga_id_foreign');
		});
		Schema::table('ijazah_profile', function(Blueprint $table) {
			$table->dropForeign('ijazah_profile_ijazah_id_foreign');
		});
		Schema::table('ijazah_profile', function(Blueprint $table) {
			$table->dropForeign('ijazah_profile_profile_id_foreign');
		});
	}
}