<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Game extends Model 
{

    protected $table = 'games';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('home', 'away', 'country_code', 'status', 'start_time');

    public function odd()
    {
        return $this->hasOne('App\Odd');
    }

}