<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('users', function(Blueprint $table) {
			$table->foreign('commission_id')->references('id')->on('commissions')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('commission_details', function(Blueprint $table) {
			$table->foreign('commission_id')->references('id')->on('commissions')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('games', function(Blueprint $table) {
			$table->foreign('league_id')->references('id')->on('leagues')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('games', function(Blueprint $table) {
			$table->foreign('odd_id')->references('id')->on('odds')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('bets', function(Blueprint $table) {
			$table->foreign('validated_by')->references('id')->on('users')
						->onDelete('no action')
						->onUpdate('no action');
		});
	}

	public function down()
	{
		Schema::table('users', function(Blueprint $table) {
			$table->dropForeign('users_commission_id_foreign');
		});
		Schema::table('commission_details', function(Blueprint $table) {
			$table->dropForeign('commission_details_commission_id_foreign');
		});
		Schema::table('games', function(Blueprint $table) {
			$table->dropForeign('games_league_id_foreign');
		});
		Schema::table('games', function(Blueprint $table) {
			$table->dropForeign('games_odd_id_foreign');
		});
		Schema::table('bets', function(Blueprint $table) {
			$table->dropForeign('bets_validated_by_foreign');
		});
	}
}