<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class League extends Eloquent {

	protected $table = 'leagues';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name', 'country_code', 'hidden');

	public function games()
	{
		return $this->hasMany('App\Game');
	}

}