<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class User extends Eloquent {

	protected $table = 'users';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name', 'username', 'password', 'role', 'superior_user_id', 'balance_total', 'balance_actual', 'rua', 'bairro', 'cidade');

	public function commission()
	{
		return $this->hasOne('App\Commission');
	}

}