<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name');
			$table->string('username')->unique();
			$table->string('password');
			$table->boolean('active')->default(1);
			$table->string('role');
			$table->integer('superior_user_id')->unsigned()->nullable();
			$table->integer('balance_total');
			$table->integer('balance_actual');
			$table->integer('commission_id')->unsigned();
			$table->timestamps();
			$table->softDeletes();
			$table->string('rua');
			$table->string('bairro');
			$table->string('cidade');
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}