<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateEmployeesTable extends Migration {

	public function up()
	{
		Schema::create('employees', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('firstname');
			$table->string('lastname');
			$table->date('birthday');
			$table->string('gender', 25);
			$table->boolean('archived');
			$table->bigInteger('company_id')->unsigned()->nullable();
		});
	}

	public function down()
	{
		Schema::drop('employees');
	}
}