<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProductsTable extends Migration {

	public function up()
	{
		Schema::create('Products', function(Blueprint $table) {
			$table->increments('id');
			$table->string('product_code', 20)->unique();
			$table->integer('category_id')->unsigned();
			$table->string('product_name', 255);
			$table->string('product_type', 30);
			$table->integer('product_unit');
			$table->integer('product_group');
			$table->string('product_catalogue', 30)->nullable();
			$table->float('product_mrp', 10,4)->default('0');
			$table->float('product_rate', 10,4)->default('0');
			$table->float('product_vat_percentage', 10,2)->default('0');
			$table->float('product_amount', 10,4)->default('0');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('Products');
	}
}