<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOperationsTable extends Migration {

	public function up()
	{
		Schema::create('operations', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('doctor_id')->unsigned()->nullable();
			$table->integer('patient_id')->unsigned()->nullable();
			$table->integer('operation_name_id')->unsigned()->nullable();
			$table->integer('workspace_id')->unsigned()->nullable();
			$table->tinyInteger('daily_instructions')->nullable();
			$table->tinyInteger('medical_prescription')->nullable();
			$table->text('notes')->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('operations');
	}
}