<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class User extends Model 
{

    protected $table = 'users';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function sources()
    {
        return $this->belongsToMany('App\Models\Resource');
    }

    public function messages()
    {
        return $this->hasMany('App\Models\Message');
    }

}