<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateRevisionsTable extends Migration {

	public function up()
	{
		Schema::create('revisions', function(Blueprint $table) {
			$table->increments('id');
			$table->string('revisionable_type', 255);
			$table->integer('revisionable_id');
			$table->integer('user_id');
			$table->string('key', 255);
			$table->text('old_value');
			$table->text('new_value');
			$table->timestamp('created_at');
			$table->timestamp('updated_at');
		});
	}

	public function down()
	{
		Schema::drop('revisions');
	}
}