<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePartnersTable extends Migration {

	public function up()
	{
		Schema::create('partners', function(Blueprint $table) {
			$table->increments('id');
			$table->enum('state', array('active', 'inactive', 'draft'));
			$table->string('customId')->nullable();
			$table->timestamps();
			$table->text('mercuriusId')->unique()->nullable();
			$table->string('companyName', 255);
			$table->string('companyRegistry', 255)->unique();
			$table->string('companyVAT',  255)->unique()->nullable();
			$table->string('companyEuVAT', 255)->nullable();
			$table->string('companyEmail', 255);
			$table->string('companyPhone', 50);
			$table->json('companyAddress');
			$table->json('companySettings');
			$table->enum('companyTyp', array('client', 'transporter', 'both'));
		});
	}

	public function down()
	{
		Schema::drop('partners');
	}
}