<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('ticket', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('User')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Project', function(Blueprint $table) {
			$table->foreign('ticket_id')->references('id')->on('ticket')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('ticket', function(Blueprint $table) {
			$table->dropForeign('ticket_user_id_foreign');
		});
		Schema::table('Project', function(Blueprint $table) {
			$table->dropForeign('Project_ticket_id_foreign');
		});
	}
}