<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class LABORATORY extends Model 
{

    protected $table = 'LABORATORIES';
    public $timestamps = false;
    protected $fillable = array('CV', 'STAFF_ID');

    public function RequiredAnalysis()
    {
        return $this->hasMany('App\REQUIRED_ANALYZE', 'LABORATORY_ID', 'ID');
    }

    public function NameOfAnalysis()
    {
        return $this->hasMany('App\NAME_OF_ANALYSIS', 'LABORATORY_ID', 'ID');
    }

    public function Staff()
    {
        return $this->belongsTo('App\Staff', 'STAFF_ID', 'ID');
    }

}