<?php

namespace App;

class REQUIRED_ANALYZE extends Eloquent {

	protected $table = 'REQUIRED_ANALYZES';
	public $timestamps = false;
	protected $fillable = array('ANALYSIS_ID', 'ANALYSIS_RESULT', 'ANALYSIS_DATE', 'MEDICAL_RECORD_ID', 'LABORATORY_ID', 'ANALYSIS_COMPLETED', 'VIEW_DR', 'VIEW_PATIENT');

	public function MedicalRecord()
	{
		return $this->belongsTo('App\MEDICAL_RECORD', 'MEDICAL_RECORD_ID', 'ID');
	}

	public function NameOfAnalysis()
	{
		return $this->belongsTo('App\NAME_OF_ANALYSIS', 'ANALYSIS_ID', 'ID');
	}

	public function Laboratory()
	{
		return $this->belongsTo('App\LABORATORY', 'LABORATORY_ID', 'ID');
	}

}