<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCompanyAgencyContactsInfoTable extends Migration {

	public function up()
	{
		Schema::create('company_agency_contacts_info', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('company_agency_id')->unsigned();
			$table->string('company_agency_person_1_name', 255);
			$table->string('company_agency_person_1_number_1', 255)->index();
			$table->string('company_agency_person_1_number_2', 255)->nullable()->index();
			$table->string('company_agency_person_1_extension', 255)->nullable()->index();
			$table->string('company_agency_person_1_email', 255)->nullable()->index();
			$table->string('company_agency_person_2_name', 255)->index();
			$table->string('company_agency_person_2_number_1', 255)->index();
			$table->string('company_agency_person_2_number_2', 255)->index();
			$table->string('company_agency_person_2_extension', 255)->nullable()->index();
			$table->string('company_agency_person_2_email', 255)->index();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('company_agency_contacts_info');
	}
}