<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUserCompanyAgencyChatsTable extends Migration {

	public function up()
	{
		Schema::create('user_company_agency_chats', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('job_posting_id')->unsigned();
			$table->integer('user_id')->unsigned();
			$table->mediumText('query_question')->index();
			$table->integer('replier_id')->index()->default('0');
			$table->datetime('date_time')->index();
			$table->tinyInteger('status')->index()->default('1');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('user_company_agency_chats');
	}
}