<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->string('user_name', 255)->index();
			$table->string('first_name', 255)->index();
			$table->string('last_name', 255)->nullable()->index();
			$table->tinyInteger('status')->index()->default('0');
			$table->tinyInteger('is_employee')->index()->default('1');
			$table->tinyInteger('is_recruiter')->index()->default('0');
			$table->string('password', 255)->index();
			$table->timestamp('last_update');
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}