<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUserTable extends Migration {

	public function up()
	{
		Schema::create('user', function(Blueprint $table) {
			$table->increments('id');
			$table->string('forename', 254);
			$table->string('surname', 254);
			$table->string('username', 254)->unique();
			$table->string('password', 256);
			$table->string('email', 254)->unique();
			$table->rememberToken('rememberToken');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('user');
	}
}