<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProjectTable extends Migration {

	public function up()
	{
		Schema::create('project', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('client_id')->unsigned()->default('11');
			$table->integer('user_id')->unsigned();
			$table->string('name', 254);
			$table->timestamps();
			$table->integer('type');
			$table->string('transfer', 254);
			$table->string('price', 30);
			$table->integer('hour_price');
			$table->smallInteger('support_hours');
			$table->smallInteger('support_frequency');
			$table->string('move_to', 254);
			$table->smallInteger('mail');
			$table->string('appendix', 254);
			$table->text('description');
			$table->smallInteger('process');
			$table->tinyInteger('status');
			$table->integer('total_hours');
		});
	}

	public function down()
	{
		Schema::drop('project');
	}
}