<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class ShippingModel extends Model 
{

    protected $table = 'shipping';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $guarded = array('user_id', 'shipping_name', 'shipping_address', 'shipping_email', 'shipping_phone', 'shipping_country', 'shipping_state', 'shipping_city');

    public function user()
    {
        return $this->belongsTo('App\User');
    }

}