<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCartsTable extends Migration {

	public function up()
	{
		Schema::create('carts', function(Blueprint $table) {
			$table->increments('id');
			$table->string('unique_id')->nullable();
			$table->integer('user_id')->unsigned();
			$table->integer('product_variant_map_id')->unsigned();
			$table->integer('quantity')->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('carts');
	}
}