<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCategoriesTable extends Migration {

	public function up()
	{
		Schema::create('categories', function(Blueprint $table) {
			$table->increments('id');
			$table->string('category_name')->nullable();
			$table->integer('parent_id')->default('0');
			$table->string('image')->nullable();
			$table->enum('status', array('Active', 'Inactive'))->nullable();
			$table->string('slug')->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('categories');
	}
}