<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateVendorProfileTable extends Migration {

	public function up()
	{
		Schema::create('vendor_profile', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id')->unsigned()->index();
			$table->string('store_name')->nullable();
			$table->string('store_address');
			$table->string('store_phone')->nullable();
			$table->string('store_city')->nullable();
			$table->string('store_logo')->nullable();
			$table->string('store_image')->nullable();
			$table->string('longitude')->nullable();
			$table->string('latitude')->nullable();
			$table->enum('store_type', array('Delivery', 'Pickup', 'Both'))->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('vendor_profile');
	}
}