<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class BrandsModel extends Eloquent {

	protected $table = 'brands';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $guarded = array('brand_name', 'status', 'slug');

	public function products()
	{
		return $this->hasMany('App\ProductsModel');
	}

}