<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class UserProfileModel extends Eloquent {

	protected $table = 'user_profile';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $guarded = array('user_id', 'address', 'city', 'phone', 'latitude', 'longitude');

	public function user()
	{
		return $this->belongsTo('App\User');
	}

}