<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUserSettingsTable extends Migration {

	public function up()
	{
		Schema::create('user_settings', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id')->unsigned();
			$table->timestamps();
			$table->boolean('share_votes')->default(0);
			$table->string('preferred_contact')->default(''email'');
		});
	}

	public function down()
	{
		Schema::drop('user_settings');
	}
}