<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateFunnelsTable extends Migration {

	public function up()
	{
		Schema::create('funnels', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('funnel_type');
			$table->string('trust_code');
			$table->float('ll95')->nullable();
			$table->float('ll998')->nullable();
			$table->float('ul95')->nullable();
			$table->float('ul998')->nullable();
			$table->float('adjusted')->nullable();
			$table->float('observed')->nullable();
			$table->string('timespan');
			$table->smallInteger('num')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('funnels');
	}
}