<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCategoriesTable extends Migration {

	public function up()
	{
		Schema::create('categories', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 50);
			$table->text('description')->nullable();
			$table->string('cover', 255)->nullable();
			$table->string('color')->nullable();
			$table->boolean('published')->default(1);
		});
	}

	public function down()
	{
		Schema::drop('categories');
	}
}