<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateModulesTable extends Migration {

	public function up()
	{
		Schema::create('modules', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('activity_id')->unsigned();
			$table->string('name_ar', 100)->index();
			$table->string('name_en', 100)->index();
			$table->text('desc_ar');
			$table->string('desc_en');
			$table->decimal('monthly_sub', 10,2);
			$table->decimal('annual_sub', 10,2);
			$table->integer('currency_id')->unsigned();
			$table->decimal('discount', 8,2)->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('modules');
	}
}