<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateParcelsTable extends Migration {

	public function up()
	{
		Schema::create('parcels', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('shipment_id')->unsigned()->nullable();
			$table->bigInteger('tracking_id')->nullable();
			$table->bigInteger('sender_id');
			$table->bigInteger('receiver_id');
			$table->bigInteger('length')->nullable();
			$table->bigInteger('width')->nullable();
			$table->bigInteger('height')->nullable();
			$table->bigInteger('weight')->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('parcels');
	}
}