<?php

namespace App\Modes\Doctors;

class Doctors extends Eloquent {

	protected $table = 'doctors';
	public $timestamps = true;

	public function cases()
	{
		return $this->hasMany('CaseDoctors', 'doctor_id');
	}

	public function assistens()
	{
		return $this->hasMany('DoctorAssistents', 'doctor_id');
	}

	public function feedbacks()
	{
		return $this->hasMany('DoctrorFeedbaks', 'doctor_id');
	}

	public function influences()
	{
		return $this->hasMany('DoctorInsurances', 'doctor_id');
	}

	public function locations()
	{
		return $this->hasMany('DoctorLocations', 'doctor_id');
	}

	public function specialities()
	{
		return $this->hasMany('DoctorSpecialities', 'doctor_id');
	}

	public function tasks()
	{
		return $this->hasMany('TaskDoctor', 'doctor_id');
	}

	public function caseNotes()
	{
		return $this->hasMany('Notes', 'user_id');
	}

	public function tags()
	{
		return $this->hasMany('Tags', 'commentable_id');
	}

}