<?php

namespace App\Modes\Document;

class Document extends Eloquent {

	protected $table = 'documents';
	public $timestamps = true;

	public function user()
	{
		return $this->belongsTo('User', 'id');
	}

	public function notes()
	{
		return $this->hasMany('Notes', 'document_id');
	}

	public function file()
	{
		return $this->hasOne('DocumentFiles', 'id');
	}

	public function task()
	{
		return $this->belongsTo('Task', 'id');
	}

	public function disorders()
	{
		return $this->belongsTo('Disorders', 'id');
	}

}