<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateNotesTable extends Migration {

	public function up()
	{
		Schema::create('notes', function(Blueprint $table) {
			$table->increments('id');
			$table->text('text');
			$table->enum('type', array('call'));
			$table->enum('user_type', array('contact_person', 'doctor'));
			$table->enum('user_id', array('case_person', 'doctor'));
			$table->date('date');
			$table->integer('commentable_id');
			$table->string('commentable_type');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('notes');
	}
}