<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateMerchantsTable extends Migration {

	public function up()
	{
		Schema::create('merchants', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name');
			$table->string('email');
			$table->string('phone');
			$table->string('logo')->nullable();
			$table->string('Identification_number');
			$table->date('birth_date');
			$table->enum('work_type', array(''));
			$table->double('salary');
			$table->double('obligations');
			$table->double('insurances');
			$table->double('total_finance');
			$table->double('profit_rate');
			$table->string('forget_code', 10)->nullable();
			$table->string('verfication_code')->nullable();
			$table->string('password');
			$table->date('verfication_code_expiration_date')->nullable();
			$table->integer('maximum_repayment_period');
			$table->integer('minmum_repayment_period');
			$table->double('profit_percentage');
			$table->boolean('ability_to_notify')->default(1);
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('merchants');
	}
}