<?php

namespace App\Models;

class Installment extends Eloquent {

	protected $table = 'installments';
	public $timestamps = true;
	protected $fillable = array('installment_date', 'amount', 'transaction_id', 'status', 'punish_of_delay');

	public function transaction()
	{
		return $this->belongsTo('App\Models\Transaction');
	}

	public function invoice()
	{
		return $this->hasOne('App\Modules\Invoice\Entities\Invoice');
	}

	public function commission()
	{
		return $this->hasOne('App\Modules\Commission\Entities\Commission');
	}

}