<?php

namespace App\Models;

class Transaction extends Eloquent {

	protected $table = 'transactions';
	public $timestamps = true;
	protected $fillable = array('amount', 'total_Installments', 'repayment_period', 'status', 'merchant_id', 'user_id');

	public function merchant()
	{
		return $this->belongsTo('App\Models\Merchant');
	}

	public function installments()
	{
		return $this->hasMany('App\Models\Merchant');
	}

	public function user()
	{
		return $this->belongsTo('App\Models\User');
	}

	public function commission()
	{
		return $this->hasOne('App\Modules\Commission\Entities\Commission');
	}

}