<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class DomainProvider extends Model 
{

    protected $table = 'domain_provider';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name', 'user_name', 'password');

    public function domains()
    {
        return $this->hasMany('Domain', 'provider_id');
    }

}