<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class ProjectService extends Eloquent {

	protected $table = 'project_service';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('project_id', 'service_id', 'domain_id', 'server_id', 'price', 'start_at', 'end_at', 'note', 'status');

	public function project_service_fields()
	{
		return $this->hasMany('ProjectServiceField', 'project_service_id');
	}

	public function project()
	{
		return $this->belongsTo('Project', 'project_id');
	}

	public function service()
	{
		return $this->belongsTo('Service', 'service_id');
	}

	public function domain()
	{
		return $this->belongsTo('Domain', 'domain_id');
	}

	public function server()
	{
		return $this->belongsTo('Server', 'server_id');
	}

}