<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateMessagesTable extends Migration {

	public function up()
	{
		Schema::create('messages', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('endpoint_id')->unsigned()->index();
			$table->integer('customer_id')->unsigned()->index();
			$table->string('verify_key')->nullable();
			$table->integer('msg_template_id')->unsigned()->nullable();
			$table->text('content');
		});
	}

	public function down()
	{
		Schema::drop('messages');
	}
}