<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Article extends Model 
{

    protected $table = 'articles';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('article_type_id', 'title', 'subtitle', 'slug', 'short', 'text', 'thumb', 'image', 'date', 'highlight', 'status', 'order');
    protected $visible = array('article_type_id', 'title', 'subtitle', 'slug', 'short', 'text', 'thumb', 'image', 'date', 'highlight', 'status', 'order');

    public function type()
    {
        return $this->belongsTo('ArticleType');
    }

}