<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class CourseUnit extends Model 
{

    protected $table = 'course_unit';
    public $timestamps = false;
    protected $fillable = array('course_id', 'unit_id', 'year_id', 'schedule_id', 'credits_ects');
    protected $visible = array('course_id', 'unit_id', 'year_id', 'schedule_id', 'credits_ects');

    public function year()
    {
        return $this->belongsTo('CourseYear');
    }

    public function schedule()
    {
        return $this->belongsTo('UnitSchedules');
    }

}